#!/usr/bin/python

import sys
import codecs

def main():
    sys.stdin = codecs.getreader('gb2312')(sys.stdin)
    sys.stdout = codecs.getwriter('utf-8')(sys.stdout)
    sys.stderr = codecs.getwriter('utf-8')(sys.stderr)
    stdin_buffer = sys.stdin.readlines()
    isWritable = False
    lineCtr = 0
    for line in stdin_buffer:
        if line.startswith('<S ID='):
            isWritable = True
            continue
        if line.startswith('</S>'):
            isWritable = False
            continue
        if isWritable:
            ll = line.strip()
            tokens = ll.split(' ')
            for i in xrange(0, len(tokens)):
                if tokens[i] != '_-NONE-':
                    sys.stdout.write(tokens[i])
                    if i < len(tokens) - 1:
                        sys.stdout.write(' ')
            sys.stdout.write('\n')
            lineCtr += 1
    sys.stderr.write('Reading finished. ' + str(lineCtr) +' sentences in total.\n')

if __name__ == '__main__':
    main()
